<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CGalleryWidgetMenu extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "3",
		"name"	=> "Album Menu",
	);

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:gallery_cats']} as i,
				{$this->tables['plugin:gallery_cats_lang']} as il
			WHERE 				
				i.cat_id = il.cat_id AND 
				il.lang_id={$widget[lang_id]} AND 
				cat_status = 1 AND 
				i.module_id={$widget[widget_module]}  AND 
				cat_date <= %d 

			ORDER BY  cat_order ASC" ,
			array(
				time()
			)
		);

		
		if (!is_array($items)) {
			return "";
		}
				
		if (is_array($items)) {	

			foreach ($items as $key => $val) {
				$items[$key]["link"] = $widget["link"] . $val["cat_url"] . "-" . $val["cat_id"] . "/";
				$items[$key]["icon"] = $this->tpl->blockREplace($val["cat_icon"] ? "Icon" : "NoIcon" , $val);
				$items[$key]["selected"] = ($val["cat_id"] == $_GET["cat_id"]) && ($_GET["module_id"] == $val["module_id"]) ? $this->tpl->blockReplace("selected") : "";
			}			
		}

		
		return $this->tpl->blockReplace(
			"Main",
			array(
				"items"	=> $base->html->Table(
					$this->tpl, 
					"" , 
					$items
				),
			),
			$widget,
			$widget["settings"],
			$widget["mod_settings"]
		);

	}
	
}


?>